//请编写一个Java程序，从指定的文件中读取内容并打印到控制台。使用 try-with-resources 结构来确保文件资源正确关闭。程序需要处理以下异常情况：
//
//文件未找到（FileNotFoundException）。
//读取文件时发生错误（IOException）。

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class FileTest {
    public static void main(String[] args) {
        File file = new File("test.txt");
        try (FileReader reader = new FileReader(file)) {
            System.out.println("读取文件成功");
            int ch;
            while ((ch = reader.read()) != -1) {
                System.out.print((char) ch);
            }
            System.out.println("\n读取完成。");
        } catch (FileNotFoundException e) {
            System.out.println("文件未找到");
            System.out.println("异常：" + e.getMessage());
        } catch (IOException e) {
            System.out.println("IO异常：" + e.getMessage());
        }
    }
}
